#include <allegro.h>
#include<stdlib.h>
struct object
{
int x;
int y;
int w;
int h;
BITMAP *image;
};

int box_check(object &obj1, object &obj2,int & ov)
{
if (obj1.y+obj1.h >= obj2.y && obj1.y <= obj2.y+obj2.h && 
    obj1.x+obj1.w >= obj2.x && obj1.x <= obj2.x+obj2.w) 
   { 
     int side = 0;
     int overlap = abs((obj1.y+obj1.h) - obj2.y);
     if(abs(obj1.y - (obj2.y+obj2.h)) < overlap)
     {
       overlap = abs(obj1.y - (obj2.y+obj2.h));
       side = 1;
     }
     if(abs((obj1.x+obj1.w) - obj2.x) < overlap)
     {
       overlap = abs((obj1.x+obj1.w) - obj2.x);
       side = 2;
     }
     if(abs(obj1.x - (obj2.x+obj2.w)) < overlap)
     {
       overlap = abs(obj1.x - (obj2.x+obj2.w));
       side = 3;
     }
     ov = overlap;
     return side;
   }
else return -1;
}

volatile long speed_counter = 0;
void increment_speed_counter()
{
  speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

int main(int argc, char *argv[]) 
{ 

    allegro_init();
    install_keyboard();
    install_timer();
    int frame=0;
	int frame_rate=30;
	int SCREENRESX = 640;
    int SCREENRESY = 480;
    LOCK_VARIABLE(speed_counter);
    install_int_ex(increment_speed_counter, BPS_TO_TIMER(frame_rate));
    LOCK_FUNCTION(increment_speed_counter);
    set_color_depth(16);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED,SCREENRESX,SCREENRESY,0,0);
    int speed=4;
BITMAP *image1=NULL;
image1=load_bitmap("guy.bmp",NULL);
BITMAP *image2=NULL;
image2=load_bitmap("floor.bmp",NULL);
BITMAP *buffer=NULL;
buffer=create_bitmap(SCREENRESX,SCREENRESY);
int wall_num=4;
int gravity=1;
int vspeed=0;
int can_jump=0;
object player;
player.x = 0;
player.y = 0;
player.w = image1->w;
player.h = image1->h;
player.image = image1;
object col[wall_num];
for(int i=0; i<wall_num; i++)
{
col[i].x=(32*i);
col[i].y=150;
col[i].w=image2->w;
col[i].h=image2->h;
col[i].image = image2;
}

int walk_l = true;
int walk_r = true;
int walk_d = true;
int walk_u = true;
int overlap;
int collision_state;

while(!key[KEY_ESC])
{
while(speed_counter>0)
{
if(walk_d==true)
{
player.y-=vspeed;
vspeed-=gravity;
}
else
{vspeed=0;}
                      
                      

overlap = 0;walk_l = true;walk_r = true;walk_u = true;walk_d = true;
for(int i=0; i<wall_num; i+=1)
{collision_state = box_check(player ,col[i],overlap);
switch (collision_state) {
  case 3 : player.x += overlap;walk_l = false;break;
  case 2 : player.x -= overlap;walk_r = false;break;
  case 1 : player.y += overlap;walk_u = false;break;
  case 0 : player.y -= overlap;walk_d = false;break;
  case -1 :
  default : break;}
                    
} 
if(key[KEY_RIGHT] && walk_r==true)
{player.x+=speed;}
if(key[KEY_LEFT] && walk_l==true)
{player.x-=speed;}
if(key[KEY_UP] && walk_d==false)
{vspeed=8; walk_d = true;}
speed_counter--;
}
draw_sprite(buffer,player.image,player.x,player.y);
for(int i=0; i<wall_num; i++)
{draw_sprite(buffer,col[i].image,col[i].x,col[i].y);}

blit(buffer, screen, 0,0,0,0,SCREENRESX,SCREENRESY);
clear_bitmap(buffer);
}
destroy_bitmap(buffer);
destroy_bitmap(player.image);
for(int i; i<wall_num; i++)
{destroy_bitmap(col[i].image);}
return 0;
}
END_OF_MAIN();
